<?php
/**
 * Get Friendship Accepted
 *
 * @package     AutomatorWP\Integrations\BuddyPress\Triggers\Get_Friendship_Accepted
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_BuddyPress_Get_Friendship_Accepted extends AutomatorWP_Integration_Trigger {

    public $integration = 'buddypress';
    public $trigger = 'buddypress_get_friendship_accepted';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_trigger( $this->trigger, array(
            'integration'       => $this->integration,
            'label'             => __( 'User gets a friendship request accepted', 'automatorwp-pro' ),
            'select_option'     => __( 'User <strong>gets a friendship request accepted</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: Number of times. */
            'edit_label'        => sprintf( __( 'User gets a friendship request accepted %1$s time(s)', 'automatorwp-pro' ), '{times}' ),
            'log_label'         => __( 'User gets a friendship request accepted', 'automatorwp-pro' ),
            'action'            => 'friends_friendship_accepted',
            'function'          => array( $this, 'listener' ),
            'priority'          => 10,
            'accepted_args'     => 3,
            'options'           => array(
                'times' => automatorwp_utilities_times_option(),
            ),
            'tags' => array_merge(
                automatorwp_utilities_times_tag()
            )
        ) );

    }

    /**
     * Trigger listener
     *
     * @since 1.0.0
     *
     * @param int $friendship_id
     * @param int $initiator_user_id
     * @param int $friend_user_id
     */
    public function listener( $friendship_id, $initiator_user_id, $friend_user_id ) {

        $user_id = $initiator_user_id;

        // Trigger the get friendship accepted
        automatorwp_trigger_event( array(
            'trigger'       => $this->trigger,
            'user_id'       => $user_id,
        ) );

    }

}

new AutomatorWP_BuddyPress_Get_Friendship_Accepted();